
/*
*  The Plot2D difinition.
*/

package plot;


import java.util.*;

import java.awt.*;

import util.*;
import plot.*;

/**
*  This class defines the basic plot structure for generating a 2-D
*  plot.
*
*  It may be used to generate the 2-D axes, grids, labels and tics image
*  separately from actually plotting the data.
*
*  It has separate routines for plotting the data using a simple rectangular
*  plot area with separate plot lines for each plot item (data line)
*/
public class Plot2D
   {

   String title = "Title";
   String h_axis_title = "X-Axis";
   String v_axis_title = "Y-Axis";

   double x_min;
   double x_max;
   double y_min;
   double y_max;

   Axis axis_x = null;
   Axis axis_y = null;

   ArrayList<PlotItem> plot_items = null;

   static ArrayList<String> marker_types = null;
   HashMap<String, Boolean> marker_available = null;

   Color title_color = Color.BLACK;
   Color grid_color = Color.darkGray;
   Color plot_color = Color.BLACK;

   double x_values_max = 1.0;
   double x_values_min = 0.0;
   double x_values_range = 1.0;

   double y_values_max = 1.0;
   double y_values_min = 0.0;
   double y_values_range = 1.0;

   boolean display_tics = true;
   boolean display_grid = true;
   boolean display_frame = true;

   /**
   *  Create the plot object with the given titles/labels.
   *  @param title the overall plot title to use.
   *  @param h_axis_title the title for the horizontal axis.
   *  @param v_axis_title the title for the vertical axis.
   */
   public Plot2D(String title,
               String h_axis_title,
               String v_axis_title)
      {
      this.title = title;
      this.h_axis_title = h_axis_title;
      this.v_axis_title = v_axis_title;

/*
      System.out.println("Plot2D Constructor on ENTRY:\n"
                       + "   title = " + this.title + "\n"
                       + "   h_axis_title = " + this.h_axis_title + "\n"
                       + "   v_axis_title = " + this.v_axis_title + "\n"
                        );
*/

      this.axis_x = new Axis(this.h_axis_title);
      this.axis_y = new Axis(this.v_axis_title);

      this.plot_items = new ArrayList<PlotItem>();

/*
      System.out.println("Plot2D Constructor on EXIT.");
*/
      }

   /**
   *  Store another set of plot points (a single line) along with
   *  their color.
   *  @param key_string the key string for the line.
   *  @param x_values the array of x-values.
   *  @param y_values the array of y-values.
   *  @param color the color for the line.
   */
   public PlotItem storePlotValues(String key_string,
                                   double [] x_values,
                                   double [] y_values,
                                   Color color)
      {
/*
      System.out.println("Plot2D::storePlotValues on ENTRY:\n"
                       + "   key_string = " + key_string + "\n"
                        );
*/

      PlotItem plot_item = new PlotItem(key_string, x_values, y_values, color);

      boolean x_limits_changed = false;
      boolean y_limits_changed = false;

      if (this.plot_items.size() < 1)
         {
         this.x_values_max = plot_item.x_data_max;
         this.x_values_min = plot_item.x_data_min;
         x_limits_changed = true;
         this.y_values_max = plot_item.y_data_max;
         this.y_values_min = plot_item.y_data_min;
         y_limits_changed = true;
         }
      else
         {
         if (this.x_values_max < plot_item.x_data_max)
            {
            this.x_values_max = plot_item.x_data_max;
            x_limits_changed = true;
            }
         if (this.x_values_min > plot_item.x_data_min)
            {
            this.x_values_min = plot_item.x_data_min;
            x_limits_changed = true;
            }

         if (this.y_values_max < plot_item.y_data_max)
            {
            this.y_values_max = plot_item.y_data_max;
            y_limits_changed = true;
            }
         if (this.y_values_min > plot_item.y_data_min)
            {
            this.y_values_min = plot_item.y_data_min;
            y_limits_changed = true;
            }
         }

      this.plot_items.add(plot_item);

      if (x_limits_changed)
         {
         try
            {
            axis_x.updateAxis(this.h_axis_title,
                              this.x_values_min,
                              this.x_values_max,
                              false,
                              false);
            }
         catch (Exception except)
            {
            System.out.println("Plot2D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }
      if (y_limits_changed)
         {
         try
            {
            axis_y.updateAxis(this.v_axis_title,
                              this.y_values_min,
                              this.y_values_max,
                              false,
                              true);
            }
         catch (Exception except)
            {
            System.out.println("Plot2D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }

/*
      System.out.println("Plot2D::storePlotValues on EXIT.");
*/
      return(plot_item);
      }

   /**
   *  Store another set of plot points (a single line) along with
   *  their color.
   *  @param key_string the key string for the line.
   *  @param x_values the array of double x-values.
   *  @param y_values the array of integer y-values.
   *  @param color the color for the line.
   */
   public PlotItem storePlotValues(String key_string,
                                   double [] x_values,
                                   int [] y_values,
                                   Color color)
      {
/*
*/
      System.out.println("Plot2D::storePlotValues on ENTRY:\n"
                       + "   key_string = " + key_string + "\n"
                        );
      for (int value_index = 0;
           value_index < x_values.length;
           value_index++)
         {
         double x_value = x_values[value_index];
         double y_value = (double) y_values[value_index];

         String out_line = String.format("Plot2D: %3d (%9.3g, %9.3g)",
                                         value_index,
                                         x_value,
                                         y_value);
         System.out.println(out_line);
         }

      PlotItem plot_item = new PlotItem(key_string, x_values, y_values, color);

      boolean x_limits_changed = false;
      boolean y_limits_changed = false;

      if (this.plot_items.size() < 1)
         {
         this.x_values_max = plot_item.x_data_max;
         this.x_values_min = plot_item.x_data_min;
         x_limits_changed = true;
         this.y_values_max = plot_item.y_data_max;
         this.y_values_min = plot_item.y_data_min;
         y_limits_changed = true;
         }
      else
         {
         if (this.x_values_max < plot_item.x_data_max)
            {
            this.x_values_max = plot_item.x_data_max;
            x_limits_changed = true;
            }
         if (this.x_values_min > plot_item.x_data_min)
            {
            this.x_values_min = plot_item.x_data_min;
            x_limits_changed = true;
            }

         if (this.y_values_max < plot_item.y_data_max)
            {
            this.y_values_max = plot_item.y_data_max;
            y_limits_changed = true;
            }
         if (this.y_values_min > plot_item.y_data_min)
            {
            this.y_values_min = plot_item.y_data_min;
            y_limits_changed = true;
            }
         }

      this.plot_items.add(plot_item);

      if (x_limits_changed)
         {
         try
            {
            axis_x.updateAxis(this.h_axis_title,
                              this.x_values_min,
                              this.x_values_max,
                              false,
                              false);
            }
         catch (Exception except)
            {
            System.out.println("Plot2D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }
      if (y_limits_changed)
         {
         try
            {
            axis_y.updateAxis(this.v_axis_title,
                              this.y_values_min,
                              this.y_values_max,
                              false,
                              true);
            }
         catch (Exception except)
            {
            System.out.println("Plot2D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }

/*
      System.out.println("Plot2D::storePlotValues on EXIT.");
*/
      return(plot_item);
      }

   /**
   *  Store a set of plot points (a single line) by selecting columns out
   *  of a "Table" array of rows, each with an array of columns, along with
   *  their color.  An array list of ArrayList entries is passed in
   *  and the indices select which indices to pick out of each of
   *  the ArrayList entries for each of the variables.
   *  @param key_string the key string for the line.
   *  @param values the ArrayList of entries of ArrayList values.
   *  @param first_entry_index the index of the first (x) value.
   *  @param second_entry_index the index of the second (y) value.
   *  @param color the color for the dot and line.
   */
   public PlotItem storePlotValues(String key_string,
                                   ArrayList<ArrayList<Double>> values,
                                   int first_entry_index,
                                   int second_entry_index,
                                   Color color)
      {
/*
      System.out.println("Plot2D::storePlotValues on ENTRY:\n"
                       + "   key_string = " + key_string + "\n"
                        );
*/
      PlotItem plot_item = new PlotItem(key_string,
                                        values,
                                        first_entry_index,
                                        second_entry_index,
                                        color);

      boolean x_limits_changed = false;
      boolean y_limits_changed = false;

      if (this.plot_items.size() < 1)
         {
         this.x_values_max = plot_item.x_data_max;
         this.x_values_min = plot_item.x_data_min;
         x_limits_changed = true;
         this.y_values_max = plot_item.y_data_max;
         this.y_values_min = plot_item.y_data_min;
         y_limits_changed = true;
         }
      else
         {
         if (this.x_values_max < plot_item.x_data_max)
            {
            this.x_values_max = plot_item.x_data_max;
            x_limits_changed = true;
            }
         if (this.x_values_min > plot_item.x_data_min)
            {
            this.x_values_min = plot_item.x_data_min;
            x_limits_changed = true;
            }

         if (this.y_values_max < plot_item.y_data_max)
            {
            this.y_values_max = plot_item.y_data_max;
            y_limits_changed = true;
            }
         if (this.y_values_min > plot_item.y_data_min)
            {
            this.y_values_min = plot_item.y_data_min;
            y_limits_changed = true;
            }
         }

      this.plot_items.add(plot_item);

      if (x_limits_changed)
         {
         try
            {
            axis_x.updateAxis(this.h_axis_title,
                              this.x_values_min,
                              this.x_values_max,
                              false,
                              false);
            }
         catch (Exception except)
            {
            System.out.println("Plot2D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }
      if (y_limits_changed)
         {
         try
            {
            axis_y.updateAxis(this.v_axis_title,
                              this.y_values_min,
                              this.y_values_max,
                              false,
                              true);
            }
         catch (Exception except)
            {
            System.out.println("Plot2D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }

/*
      System.out.println("Plot2D::storePlotValues on EXIT.");
*/
      return(plot_item);
      }


   /**
   *  Get the marker types available.  These must concur with the list
   *  in PlotPanel.
   *  @return the ArrayList of marker type strings.
   */
   public static ArrayList<String> getMarkerTypes()
      {
      if (marker_types == null)
         {
         marker_types = new ArrayList<String>();
         marker_types.add("triangle");
         marker_types.add("filled_triangle");
         marker_types.add("delta");
         marker_types.add("filled_delta");
         marker_types.add("square");
         marker_types.add("filled_square");
         marker_types.add("circle");
         marker_types.add("filled_circle");
         marker_types.add("cross");
         marker_types.add("ex");
         }

      return(marker_types);
      }


   /**
   *  Get the marker availabilities.
   *  @return the ArrayList of marker availability flags.
   */
   public HashMap<String, Boolean> getMarkerAvailabilities()
      {
      if (marker_types == null)
         {
         getMarkerTypes();
         }
      if (marker_available == null)
         {
         marker_available = new HashMap<String, Boolean>();
         for (int marker_index = 0;
              marker_index < marker_types.size();
              marker_index++)
            {
            String marker_string = marker_types.get(marker_index);
            marker_available.put(marker_string, new Boolean(true));
            }
         }

      return(marker_available);
      }


   /**
   *  Get the designated plot item structure reference.
   *  @param item_index the index of the ploit item to fetch.
   *  @return the reference to the desired PlotItem class instance.
   */
   public PlotItem getPlotItem(int item_index)
      {
/*
      System.out.println("Plot2D::getPlotItem on ENTRY:\n"
                       + "   item_index = " + item_index + "\n"
                        );
*/
      return(this.plot_items.get(item_index));
      }

   /**
   *  Set the menu entries according to the status of the plot items.
   */
   public ArrayList<PlotItem> getPlotItems()
      {
      return(this.plot_items);
      }
   }

