
/*
*  The GUI items to support viewing and manipulating data and its relationships.
*/

package plot;


import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.swing.tree.*;
import javax.swing.table.*;

import util.*;
import plot.*;


public class plot_gui extends JApplet
   {
   static final long serialVersionUID = 1L;

   /*
   *  The Plot2D and PlotFrame window.
   */
   Plot2D plot_random = null;
   Plot2D plot_log = null;
   Plot2D plot_sine = null;

   PlotFrame plot_random_frame = null;
   PlotFrame plot_log_frame = null;
   PlotFrame plot_sine_frame = null;

   /*
   *  A simple text area to display status messages.
   */
   public static JTextField text_field = null;

   private static plot_gui base_object = null;
   /*
   *  A progress bar and a slider.
   */
   private JProgressBar prog_bar = new JProgressBar();
   private JSlider slide_bar = new JSlider(JSlider.HORIZONTAL, 0, 100, 60);

   static String dir_path = null;

   private ActionListener menu_act_listener =
      new ActionListener()
         {
         public void actionPerformed(ActionEvent e)
            {
            setTextField(((JMenuItem)e.getSource()).getText());
            }
         };

   private ActionListener tool_act_listener =
      new ActionListener()
         {
         public void actionPerformed(ActionEvent event)
            {
            String selected_text = ((JMenuItem)event.getSource()).getText();
/*
            System.out.println("ActionListener.actionPerformed() on ENTRY:\n"
                             + "   selected_text = " + selected_text + "\n"
                             + "   event: " + event + "\n"
                              );
*/
            if (selected_text.equals("Plot2D Random"))
               {
               if (plot_random != null)
                  {
                  if (plot_random_frame == null)
                     {
                     plot_random_frame = new PlotFrame(null, plot_random);
                     plot_random_frame.display(plot_random);
                     }
                  plot_random_frame.setVisible(true);
                  }
               }
            else if (selected_text.equals("Plot2D Logs"))
               {
               if (plot_log != null)
                  {
                  if (plot_log_frame == null)
                     {
                     plot_log_frame = new PlotFrame(null, plot_log);
                     plot_log_frame.display(plot_log);
                     }
                  plot_log_frame.setVisible(true);
                  }
               }
            else if (selected_text.equals("Plot2D sin/cos"))
               {
               if (plot_sine != null)
                  {
                  if (plot_sine_frame == null)
                     {
                     plot_sine_frame = new PlotFrame(null, plot_sine);
                     plot_sine_frame.display(plot_sine);
                     }
                  plot_sine_frame.setVisible(true);
                  }
               }
            validate();
            }
         };

/*
   private PopupActionListener al = new PopupActionListener();
*/
   private PopupMenuListener ml = new PopupMenuListener();

   private JMenu[] menus =
      {
      new JMenu("File"),
      new JMenu("Edit"),
      new JMenu("Plot"),
      new JMenu("Tools"),
      new JMenu("Help")
      };

   private JMenuItem[] file_items =
      {
      new JMenuItem("New"),
      new JMenuItem("Open"),
      new JMenuItem("Save"),
      new JMenuItem("Save As"),
      new JMenuItem("Print"),
      new JMenuItem("Exit")
      };
   private JMenuItem[] edit_items =
      {
      new JMenuItem("Fee"),
      new JMenuItem("Fi"),
      new JMenuItem("Fo")
      };
   private JMenu[] plot_items =
      {
      new JMenu("Item Plots"),
      new JMenu("Plot Flags")
      };
   private JMenuItem[] tool_items =
      {
      new JMenuItem("Plot2D Random"),
      new JMenuItem("Plot2D Logs"),
      new JMenuItem("Plot2D sin/cos"),
      };

   private JMenuItem[] help_items =
      {
      new JMenuItem("Oops!"),
      new JMenuItem("Huh?")
      };

   public plot_gui()
      {
      init();
      }

   public void init()
      {
      try
         {
         javax.swing.SwingUtilities.invokeAndWait(
            new Runnable()
               {
               public void run()
                  {
                  startGui();
                  }
               }
            );
         }
      catch (Exception e)
         {
         System.err.println("startGUI didn't successfully complete");
         }
      }

   public void startGui()
      {
      base_object = this;

      text_field = new JTextField(100);

      PlotItem plot_item = null;

      plot_random = new Plot2D("Random X vs Y", "x-axis title", "y-axis title");
      plot_log = new Plot2D("Function log(x) (natural and base 10)",
                          "x value",
                          "log(x)");
      plot_sine = new Plot2D("Function sin(x) and cos(x)", "x value", "y");

      System.out.println("plot_gui::startGui() Generating the plot_items.");

      double [] x_values = null;
      double [] y_values = null;
      double x_value = 0.0;

      /*
      * Create the arrays of x and y random values.
      */
      Random random = new Random(27981);

      x_values = new double[12];
      y_values = new double[12];
      for (int value_index = 0;
           value_index < 12;
           value_index++)
         {
         x_values[value_index] = value_index;
         y_values[value_index] = random.nextDouble();
         }
      plot_random.storePlotValues("Uniform Distribution Values #1",
                                  x_values,
                                  y_values,
                                  Color.RED);

      x_values = new double[12];
      y_values = new double[12];
      for (int value_index = 0;
           value_index < 12;
           value_index++)
         {
         x_values[value_index] = value_index;
         y_values[value_index] = random.nextGaussian();
         }
      plot_random.storePlotValues("Gaussian Distribution Values #2",
                                  x_values,
                                  y_values,
                                  Color.BLUE);

      x_values = new double[12];
      y_values = new double[12];
      for (int value_index = 0;
           value_index < 12;
           value_index++)
         {
         x_values[value_index] = Math.random() * 0.8 + 0.1;
         y_values[value_index] = Math.random() * 0.8 + 0.1;
         }
      plot_random.storePlotValues("Random X and Y Values #3",
                                  x_values,
                                  y_values,
                                  Color.GREEN);

      /*
      *  Create the log plots.
      */
      System.out.println("plot_gui::StartGUI() STATUS:\n"
                       + "   Building the log plots.");
      x_values = new double[450];
      y_values = new double[450];
      x_value = 0.01;
      for (int value_index = 0;
           value_index < 450;
           value_index++)
         {
         x_values[value_index] = x_value;
         y_values[value_index] = Math.log10(x_value);
         x_value += 0.01;
         }
      plot_log.storePlotValues("Function Log Base 10 Values",
                               x_values,
                               y_values,
                               Color.RED);
      x_values = new double[450];
      y_values = new double[450];
      x_value = 0.01;
      for (int value_index = 0;
           value_index < 450;
           value_index++)
         {
         x_values[value_index] = x_value;
         y_values[value_index] = Math.log(x_value);
         x_value += 0.01;
         }
      plot_log.storePlotValues("Function Natural Log Values",
                               x_values,
                               y_values,
                               Color.BLUE);

      /*
      *  Create the sin/cos plots.
      */
      System.out.println("plot_gui::StartGUI() STATUS:\n"
                       + "   Building the trig plots.");
      System.out.println("sin(x) values:");
      x_values = new double[21];
      y_values = new double[21];
      x_value = -Math.PI;
      for (int value_index = 0;
           value_index < 21;
           value_index++)
         {
         double y_value = Math.sin(x_value);
         x_values[value_index] = x_value;
         y_values[value_index] = y_value;
         System.out.println(String.format("   %3d  (%5.2f, %5.3f)",
                                          value_index,
                                          x_value,
                                          y_value)
                           );
         x_value += Math.PI * 0.1;
         }
      plot_item = plot_sine.storePlotValues("Function sin(x) Values",
                                            x_values,
                                            y_values,
                                            Color.RED);
      plot_item.setMarkerType(plot_sine, "triangle");
      plot_item.setMarkerRadius(3);

      System.out.println("cos(x) values:");
      x_values = new double[21];
      y_values = new double[21];
      x_value = -Math.PI;
      for (int value_index = 0;
           value_index < 21;
           value_index++)
         {
         double y_value = Math.cos(x_value);
         x_values[value_index] = x_value;
         y_values[value_index] = y_value;
         System.out.println(String.format("   %3d  (%5.2f, %5.3f)",
                                          value_index,
                                          x_value,
                                          y_value)
                           );
         x_value += Math.PI * 0.1;
         }
      plot_item = plot_sine.storePlotValues("Function cos(x) Values",
                                            x_values,
                                            y_values,
                                            Color.GREEN);

      plot_item.setMarkerType(plot_sine, "square");
      plot_item.setMarkerRadius(3);

      /*
      *  Give all the menu items the "text echo" handler.
      */

      /*
      *  Set up the "File" menu entries and assign their event handlers.
      */
      /* "New" is dummied. */
      file_items[0].addActionListener(menu_act_listener);
      file_items[1].addActionListener(menu_act_listener);
      file_items[2].addActionListener(menu_act_listener);
      file_items[3].addActionListener(menu_act_listener);

      /* "Print" is dummied. */
      file_items[4].addActionListener(menu_act_listener);

      file_items[5].addActionListener(
               new ActionListener()
                  {
                  public void actionPerformed(ActionEvent e)
                     {
                     System.exit(0);
                     }
                  }
               );
      file_items[5].addActionListener(menu_act_listener);

      menus[0].add(file_items[0]);
      menus[0].add(file_items[1]);
      menus[0].add(file_items[2]);
      menus[0].add(file_items[3]);
      menus[0].add(file_items[4]);
      menus[0].add(file_items[5]);


      /* "Edit" menu items. (DUMMIED). */
      edit_items[0].addActionListener(menu_act_listener);
      edit_items[1].addActionListener(menu_act_listener);
      edit_items[2].addActionListener(menu_act_listener);

      menus[1].add(edit_items[0]);
      menus[1].add(edit_items[1]);
      menus[1].add(edit_items[2]);


      /*
      *  Set up the "Plot2D" menu entry handlers.
      */
      plot_items[0].addMenuListener(ml);
      plot_items[1].addMenuListener(ml);

      menus[2].add(plot_items[0]);
      menus[2].add(plot_items[1]);


      /*
      *  Set up the "Tools" menu entry handlers.
      */
      tool_items[0].addActionListener(tool_act_listener);
      tool_items[0].addActionListener(menu_act_listener);
      tool_items[1].addActionListener(tool_act_listener);
      tool_items[1].addActionListener(menu_act_listener);
      tool_items[2].addActionListener(tool_act_listener);
      tool_items[2].addActionListener(menu_act_listener);

      /*
      *  Store the "Tools" menu entries.
      */
      menus[3].add(tool_items[0]);
      menus[3].add(tool_items[1]);
      menus[3].add(tool_items[2]);


      /*
      *  Set up the "Help" menu entry handlers (DUMMIED).
      */
      help_items[0].addActionListener(menu_act_listener);
      help_items[1].addActionListener(menu_act_listener);

      /*
      *  Store the "Help" menu entries.
      */
      menus[4].add(help_items[0]);
      menus[4].add(help_items[1]);


      /*
      *  Build the menu bar with the above menus.
      */
      JMenuBar menu_bar = new JMenuBar();
      for (int menu_index = 0;
           menu_index < menus.length;
           menu_index++)
         {
         menu_bar.add(menus[menu_index]);
         }
      setJMenuBar(menu_bar);


      /*
      *  Generate the container for the rest of the window's contents.
      */
      Container cont = getContentPane();

      /*
      *  The status text field.
      */
      text_field.setToolTipText("See the status info here!");

      slide_bar.setBorder(new TitledBorder("Slide Me"));
      slide_bar.setValue(0);
      slide_bar.setPaintTicks(true);
      slide_bar.setMajorTickSpacing(20);
      slide_bar.setMinorTickSpacing(5);
      slide_bar.setToolTipText("Slide me and watch the progress bar!");

      prog_bar.setModel(slide_bar.getModel());
      prog_bar.setToolTipText("Slide the bar and watch me!");

      JPanel top_panel = new JPanel();
      top_panel.setLayout(new GridLayout(3, 1));
      top_panel.add(text_field);
      top_panel.add(prog_bar);
      top_panel.add(slide_bar);

      cont.add(top_panel, BorderLayout.NORTH);
      }

   /**
   *  The popup menu listener for the menus.
   */
   class PopupMenuListener implements MenuListener
      {
      public void menuSelected(MenuEvent e)
         {
         JMenu sm = (JMenu)e.getSource();
         String selected_text = sm.getText();
         JCheckBox cb = null;

         if (selected_text.equals("Item Plots"))
            {
/*
            System.out.println("PopupMenuListener::menuSelected() Status:\n"
                             + "   \"Item Plots\" submenu activated.");
*/
            sm.removeAll();
            for (PlotItem plot_item: plot_random.getPlotItems())
               {
               cb = new JCheckBox(plot_item.getTitle());
/*
               cb.addActionListener(al);
*/
               cb.setSelected(plot_item.isSelected());
               sm.add(cb);
               }
            }
         }

      public void menuCanceled(MenuEvent e)
         {
         }

      public void menuDeselected(MenuEvent e)
         {
         }
      }

   /**
   *  Set the contents of the text field.
   *  @param new_text the new text to display.
   */
   public static void setTextField(String new_text)
      {
      if (new_text != null)
         {
         text_field.setText(new_text);
         }
      else
         {
         text_field.setText("   ");
         }
      }

   public static plot_gui GetBaseObject()
      {
      return(base_object);
      }

   public static void main(String [] args)
      {
      Console.run(new plot_gui(), 500, 700);
      }
   }

