
package util;

import java.util.*;
import java.io.*;


/**
*  This class provides a common class type inteface and common data fields
*  for the various feature types, allowing them to be placed in ArrayList,
*  HashMap, and other Java class generics structures.
*/
public abstract class Feature
   {

   /**
   *  The feature type.
   */
   String type = null;

   /**
   * The number of dimensions for the space this feature is in.
   */
   Integer num_dims = null;


   /**
   * The prefix to prepend when printing out.
   */
   String prefix = "";

   /**
   *  Constructor for a feature representation.
   *  @param type the feature type.
   */
   public Feature(String type, int num_dims)
      {
/*
      System.out.println("Feature:Constructor() on ENTRY:\n"
                       + "   type = " + type + "\n"
                        );
*/
      this.type = type;
      this.num_dims = num_dims;
      }

   /**
   *  Get the type of the feature.
   *  @return the type of the feature.
   */
   public String getType()
      {
      return(this.type);
      }

   /**
   *  Get the number of dimensions in which the feature is embedded.
   *  @return the number of dimensions.
   */
   public Integer getNumDims()
      {
      return(this.num_dims);
      }

   /**
   *  Generate a string representation.
   *  @return the string representation.
   */
   public String toString()
      {
      String out_string = this.prefix
                        + "FEATURE "
                        + this.type
                        + "  "
                        + this.num_dims
                        + "\n"
                         ;
      return(out_string);
      }

   /**
   *  Print the string representation.
   */
   public void Print()
      {
      System.out.print(this);
      }

   /**
   *  Set the print prefix string.
   */
   public void setPrefix(String prefix)
      {
      if (prefix != null)
         {
         this.prefix = prefix;
         }
      else
         {
         this.prefix = "";
         }
      }

   /*
   * The functions for determining the feature type efficiently.
   */

   /*
   * Is it a Point?
   * @returns true if it is.
   */
   public boolean isPoint()
      {
      return(false);
      }

   /*
   * Is it a Sequence?
   * @returns true if it is.
   */
   public boolean isSequence()
      {
      return(false);
      }

   /*
   * Is it a Interval?
   * @returns true if it is.
   */
   public boolean isInterval()
      {
      return(false);
      }

   /*
   * Is it a Region?
   * @returns true if it is.
   */
   public boolean isRegion()
      {
      return(false);
      }

   }
