
package util;

import java.util.*;
import java.util.regex.*;
import java.awt.geom.*;

import util.geom.*;

/**
*  This class enables parsing of various Java preexisting data types:
*
*     Boolean, Integer, Float, Double, Rectangle2D, and Point2D
*
*  Some of the tecniques are customized and used in several of the custom
*  data types, including:
*
*     Vector2D, Vector3D, and VectorND
*     Point2D and Point3D
*
*/
public class Parsable
   {

   static boolean debug_flag = false;

   public static String basic_pattern_regex = null;
   public static Pattern basic_pattern = null;

   /**
   * Rectangle2D value regex
   */
   static String rectangle2d_simple_regex = "\\s*"
                                          + "("
                                          + "\\("
                                          + "[^\\)]*"
                                          + "\\)"
                                          + "\\s*"
                                          + ":"
                                          + "\\s*"
                                          + "\\("
                                          + "[^\\)]*"
                                          + "\\)"
                                          + ")"
                                          ;
   static Pattern rectangle2d_simple_pattern = null;

   /**
   * Rectangle2D value regex
   */
   static String rectangle2d_regex = "\\s*"
                                   + "\\("
                                   + "\\s*"
                                   + "([^,\\s]+)"
                                   + "\\s*"
                                   + ","
                                   + "\\s*"
                                   + "([^\\)\\s]+)"
                                   + "\\s*"
                                   + "\\)"
                                   + "\\s*"
                                   + ":"
                                   + "\\s*"
                                   + "\\("
                                   + "\\s*"
                                   + "([^,\\s]+)"
                                   + "\\s*"
                                   + ","
                                   + "\\s*"
                                   + "([^\\)\\s]+)"
                                   + "\\s*"
                                   + "\\)"
                                   ;

   static Pattern rectangle2d_value_pattern = null;


   /**
   *  Get the basic "locatable" pattern for scanning text for an occurrance
   *  of a possible match..
   *  @return the pattern for locating candidate substrings.
   */
   public static Pattern getBasicPattern()
      {
      if (basic_pattern == null)
         {
         basic_pattern = Pattern.compile(basic_pattern_regex);
         }
      return(basic_pattern);
      }

   /**
   *  Determines whether the basic pattern is in the line.
   *  @param line the string of text to search for the pattern.
   *  @return the matcher for the occrrance of the object's pattern or null
   *     if it is not found.
   */
   public static Matcher findMatchLine(String line)
      {
      Matcher matcher = null;
      if (basic_pattern == null)
         {
         basic_pattern = Pattern.compile(basic_pattern_regex);
         }
      if (line != null)
         {
         matcher = basic_pattern.matcher(line);
         }
      return(matcher);
      }

   /**
   *  Extracts the string where the basic pattern occurs in the line.
   *  @param line the string of text to search for the pattern.
   *  @return the string that was matched, or null if not found.
   */
   public static String getMatchingString(String line)
      {
      String match = null;
      return(match);
      }


  /**
  *  Parses the given string and returns the object value.
  *  @return the reference to the new object with the included value
  *     or null if it failed.
  */
   public static Object getValueObject(String line)
      {
      Object value_obj = null;
      return(value_obj);
      }


   /**
   *  Extract the Boolean value object from the string (true or 1 gives "TRUE").
   * @return the reference to the value object or null if in error.
   */
   public static Boolean parseBooleanValue(String val_string)
      {
      Boolean value = null;
      if (val_string == null)
         {
         }
      else if (val_string.matches(".*null.*"))
         {
         }
      else if (val_string.toLowerCase().matches(".*true.*"))
         {
         value = true;
         }
      else if (val_string.toLowerCase().matches(".*1.*"))
         {
         value = true;
         }
      else
         {
         value = false;
         }
      return(value);
      }


   /**
   *  Extract the Integer value object from the string.
   * @return the reference to the value object.
   */
   public static Integer parseIntegerValue(String val_string)
      {
      Integer value = null;
      if (val_string == null)
         {
         }
      else if (val_string.matches(".*null.*"))
         {
         }
      else
         {
         value = Integer.parseInt(val_string);
         }
      return(value);
      }


   /**
   *  Extract the Float value object from the string.
   * @return the reference to the value object.
   */
   public static Float parseFloatValue(String val_string)
      {
      Float value = null;
      if (val_string == null)
         {
         }
      else if (val_string.matches(".*null.*"))
         {
         }
      else if (val_string.matches(".*Infinity.*"))
         {
         value = Float.POSITIVE_INFINITY;
         }
      else if (val_string.matches(".*-Infinity.*"))
         {
         value = Float.NEGATIVE_INFINITY;
         }
      else if (val_string.matches(".*NaN.*"))
         {
         value = Float.NaN;
         }
      else
         {
         value = Float.parseFloat(val_string);
         }
      return(value);
      }


   /**
   *  Extract the Double value object from the string.
   * @return the reference to the value object.
   */
   public static Double parseDoubleValue(String val_string)
      {
      Double value = null;
      if (val_string == null)
         {
         }
      else if (val_string.matches(".*null.*"))
         {
         }
      else if (val_string.matches(".*Infinity.*"))
         {
         value = Double.POSITIVE_INFINITY;
         }
      else if (val_string.matches(".*-Infinity.*"))
         {
         value = Double.NEGATIVE_INFINITY;
         }
      else if (val_string.matches(".*NaN.*"))
         {
         value = Double.NaN;
         }
      else
         {
         value = Double.parseDouble(val_string);
         }
      return(value);
      }


   /**
   *  Get the matcher for the Rectangle2D simple pattern.
   *  @param line the text line to search.
   *  @return the reference to the matcher object or a null if it failed.
   */
   public static Matcher getRectangle2DSimpleMatcher(String line)
      {
      Matcher matcher = null;

      if (rectangle2d_simple_pattern == null)
         {
         rectangle2d_simple_pattern = Pattern.compile(rectangle2d_simple_regex);
         }
      matcher = rectangle2d_simple_pattern.matcher(line);

      return(matcher);
      }


   /**
   *  Extract the Rectangle2D value object from the string.
   * @return the reference to the value object.
   */
   public static Rectangle2D parseRectangle2DValue(String val_string)
      {
      Rectangle2D value = null;

      if (rectangle2d_value_pattern == null)
         {
         rectangle2d_value_pattern = Pattern.compile(rectangle2d_regex);
         }

      if (debug_flag)
         {
         System.out.println("Parsable.parseRectangle2DValue() on ENTRY:\n"
                          + "   val_string = \""
                          + val_string
                          + "\"\n"
                          + "   rectangle2d_regex = \""
                          + rectangle2d_regex
                          + "\"\n"
                           );
         }

      Matcher value_matcher = rectangle2d_value_pattern.matcher(val_string);

      if (value_matcher != null &&
          value_matcher.find())
         {
         String val1_string = value_matcher.group(1).trim();
         String val2_string = value_matcher.group(2).trim();
         String val3_string = value_matcher.group(3).trim();
         String val4_string = value_matcher.group(4).trim();

         Double value1 = Parsable.parseDoubleValue(val1_string);
         Double value2 = Parsable.parseDoubleValue(val2_string);
         Double value3 = Parsable.parseDoubleValue(val3_string);
         Double value4 = Parsable.parseDoubleValue(val4_string);

         if (debug_flag)
            {
            System.out.println("   value = ("
                             + value1
                             + ", "
                             + value2
                             + ", "
                             + value3
                             + ", "
                             + value4
                             + ")"
                              );
            }
         value = new Rectangle2D.Double(value1, value2, value3, value4);
         }

      return(value);
      }


   /**
   *  Extract the Point2D value object from the string.
   * @return the reference to the value object.
   */
   public static Point2D parsePoint2DValue(String val_string)
      {
      Point2D value = null;

      Vector2D vector_value = Vector2D.getVector2DValue(val_string);
      if (vector_value != null)
         {
         value = new Point2D.Double(vector_value.x, vector_value.y);
         }

      return(value);
      }

   }
