
package util;


/**
*  This class allows storing triples of objects as a single entity.
*/
public class Triple<ObjType>
   {

   /*
   *  The first object of the triple.
   */
   public ObjType first = null;
   public ObjType second = null;
   public ObjType third = null;

   /**
   *  Construct the triple of the given object type references.
   *  @param first the reference to the first object.
   *  @param second the reference to the second object.
   *  @param third the reference to the third object.
   */
   public Triple(ObjType first,
                 ObjType second,
                 ObjType third)
      {
      this.first = first;
      this.second = second;
      this.third = third;
      }

   /**
   *  Construct the clone of the given triple.
   *  @param triple the reference to the triple object to be cloned.
   */
   public Triple(Triple<ObjType> triple)
      {
      this.first = triple.first;
      this.second = triple.second;
      this.third = triple.third;
      }

   /**
   *  Get the first reference of the three.
   *  @return the reference to the first of the three.
   */
   public ObjType get_first()
      {
      return(this.first);
      }

   /**
   *  Set the first reference of the three.
   *  @param first the reference to the new object.
   */
   public void set_first(ObjType first)
      {
      this.first = first;
      }

   /**
   *  Get the second reference of the three.
   *  @return the reference to the second of the three.
   */
   public ObjType get_second()
      {
      return(this.second);
      }

   /**
   *  Set the second reference of the three.
   *  @param second the reference to the new object.
   */
   public void set_second(ObjType second)
      {
      this.second = second;
      }

   /**
   *  Get the third reference of the three.
   *  @return the reference to the third of the three.
   */
   public ObjType get_third()
      {
      return(this.third);
      }

   /**
   *  Set the third reference of the three.
   *  @param third the reference to the new object.
   */
   public void set_third(ObjType third)
      {
      this.third = third;
      }

   /**
   *  Set all three of the references.
   *  @param triple the reference to the other triple.
   */
   public void set_triple(Triple<ObjType> triple)
      {
      this.first = triple.first;
      this.second = triple.second;
      this.third = triple.third;
      }

   /**
   *  Set all three of the references.
   *  @param first the reference to the first new object.
   *  @param second the reference to the second new object.
   *  @param third the reference to the third new object.
   */
   public void set_triple(ObjType first, ObjType second, ObjType third)
      {
      this.first = first;
      this.second = second;
      this.third = third;
      }

   public String toString()
      {
      String out_string = new String("");

      out_string = "(" + this.first
                 + ", " + this.second
                 + ", " + this.third
                     + ")";
      return(out_string);
      }

   public void Print()
      {
      System.out.print("(" + this.first
                     + ", " + this.second
                     + ", " + this.third
                     + ")");
      }
   }

