
package util.geom;

import java.util.*;
import java.io.*;
import java.util.regex.*;

import util.*;

/**
*  This class allows storing 3-D point coordinates.
*/
public class Point3D extends Vector3D
   {

   /**
   *  Creates a Point3D object with (0, 0, 0) as the coordinate values.
   */
   public Point3D()
      {
      }

   /**
   *  Creates a Point3D object with (x, y, and z) coordinate values.
   *  @param x the x-coordinate.
   *  @param y the y-coordinate.
   *  @param z the z-coordinate.
   */
   public Point3D(double x, double y, double z)
      {
      super(x, y, z);
      }

   /**
   *  Creates a Point3D object from a Vector3D argument's coordinate values.
   *  @param coords the other coords.
   */
   public Point3D(Vector3D coords)
      {
      super(coords.x, coords.y, coords.z);
      }

   /**
   * Creates a new Point3D object from this Point3D's coordinate values.
   * @return the new Point3D object reference.
   */
   public Point3D clone()
      {
      Point3D coords = new Point3D(this);
      return(coords);
      }


   /**
   * The Parsable routines.
   */


   /**
   *  Get the basic "locatable" pattern for scanning text for an occurrance
   *  of a possible match..
   *  @return the pattern for locating candidate substrings.
   */
   public static Pattern getBasicPattern()
      {
      if (basic_pattern == null)
         {
         basic_pattern = Pattern.compile(basic_pattern_regex);
         }
      return(basic_pattern);
      }

   /**
   *  Determines whether the basic pattern is in the line.
   *  @param line the string of text to search for the pattern.
   *  @return the matcher for the occrrance of the object's pattern or null
   *     if it is not found.
   */
   public static Matcher findMatchInLine(String line)
      {
      Matcher matcher = null;
      if (basic_pattern == null)
         {
         basic_pattern = Pattern.compile(basic_pattern_regex);
         }
      if (line != null)
         {
         matcher = basic_pattern.matcher(line);
         }
      return(matcher);
      }

   /**
   *  Extracts the string where the basic pattern occurs in the line.
   *  @param line the string of text to search for the pattern.
   *  @return the string that was matched, or null if not found.
   */
   public static String getMatchingString(String line)
      {
      String match = null;
      return(match);
      }


  /**
  *  Parses the given string and returns the object value.
  *  @param val_string the input string from which to extract the values.
  *  @return the reference to the new object with the included value
  *     or null if it failed.
  */
   public static Object getValueObject(String val_string)
      {
      Object value_obj = null;

      if (debug_flag)
         {
         System.out.println("Point2D.getValueObject(string) on ENTRY:\n"
                          + "   val_string = " + val_string + "\n"
                          + "   value_pattern = \""
                          + value_pattern
                          + "\""
                           );
         }
      Matcher value_matcher = null;

      if (value_pattern == null)
         {
         value_pattern = Pattern.compile(value_pattern_regex);
         }

      if (val_string != null)
         {
         value_matcher = value_pattern.matcher(val_string);
         }

      if (value_matcher != null &&
          value_matcher.find())
         {
         String val1_string = value_matcher.group(1).trim();
         String val2_string = value_matcher.group(2).trim();
         String val3_string = value_matcher.group(3).trim();

         if (debug_flag)
            {
            System.out.println("val1_string: " + val1_string);
            System.out.println("val2_string: " + val2_string);
            System.out.println("val3_string: " + val3_string);
            }

         Double value1 = Parsable.parseDoubleValue(val1_string);
         Double value2 = Parsable.parseDoubleValue(val2_string);
         Double value3 = Parsable.parseDoubleValue(val3_string);

         if (debug_flag)
            {
            System.out.println("   value = ("
                             + value1
                             + ", "
                             + value2
                             + ", "
                             + value3
                             + ")"
                              );
            }
         value_obj = new Point3D(value1, value2, value3);
         }
      return(value_obj);
      }
   }

