
import java.util.*;
import java.awt.*;

import plf.*;
import plot.*;

class plf_2_tst
   {
   public static void main(String args[])
      {
      System.out.println("Starting plf_2_tst:\n");

      System.out.println("plf_2_tst of Function_1D is STARTING.\n");
      System.out.println("Generating the data for a function.");

      double[] y_sin_x_values = null;
      double[] x_values = null;

      double x_min = 0.0;
      double x_max = Math.PI;

      Function_1D sin_x = null;
      Function_1D histogram = null;
      Function_1D pdf_plf = null;
      Function_1D cdf_plf = null;

      double x_incr = (x_max - x_min) / 100.0;

      y_sin_x_values = new double[101];
      x_values = new double[101];
      for (int x_index = 0;
           x_index <= 100;
           x_index++)
         {
         double x_value = x_min + x_incr * x_index;
         x_values[x_index] = x_value;
         y_sin_x_values[x_index] = Math.sin(x_value);
         }

      try
         {
         sin_x = new Function_1D("my_sin(x)", x_min, x_max, y_sin_x_values);
         }
      catch(Exception except)
         {
         System.out.println("plf_2_tst caught exception:\n"
                          + "   " + except);
         except.printStackTrace(System.out);
         }
      sin_x.Print();
      Plot2D sin_x_plot = new Plot2D("PLF of sin(x)", "x", "sin(x)");
      sin_x_plot.storePlotValues("My sin(x)",
                                 x_values,
                                 y_sin_x_values,
                                 Color.red);
      PlotFrame my_sin_x_frame = new PlotFrame("My sin(x) PLF", sin_x_plot);
      my_sin_x_frame.setVisible(true);

      x_values = new double[100000];
      double sample_count = x_values.length;
      System.out.println("Calculating the errors for "
                       + x_values.length
                       + " x values:"
                        );
      double [] my_sin_x_values = new double[x_values.length];
      double [] actual_sin_x_values = new double[x_values.length];

      double err_min = 0.0;
      double err_max = 0.0;
      double [] y_errors = new double[x_values.length];
      x_incr = (x_max - x_min) / sample_count;
      for (int x_index = 0;
           x_index < x_values.length;
           x_index++)
         {
         try
            {
            double x_value = x_min + x_incr * x_index;

            double y_Math_sin_x_value = Math.sin(x_value);
            double y_sin_x_value = sin_x.getValue(x_value);
            double y_error = Math.sin(x_value) - y_sin_x_value;

            y_errors[x_index] = y_error;
            if (err_min > y_error)
               {
               err_min = y_error;
               }
            if (err_max < y_error)
               {
               err_max = y_error;
               }
            x_values[x_index] = x_value;
            actual_sin_x_values[x_index] = y_Math_sin_x_value;
            my_sin_x_values[x_index] = y_sin_x_value;
/*
            String out_line = String.format("%3d: %8.2g (%8.2g, %8.2g) %8.2g",
                                            x_index,
                                            x_value,
                                            y_Math_sin_x_value,
                                            y_sin_x_value,
                                            y_error);
            System.out.println(out_line);
*/
            }
         catch(Exception except)
            {
            System.out.println("plf_2_tst caught exception:\n"
                             + "   " + except);
            except.printStackTrace(System.out);
            }
         }

      Plot2D err_sin_x_plot = new Plot2D("Function Errors", "x", "error");
      err_sin_x_plot.storePlotValues("Errors",
                                      x_values,
                                      y_errors,
                                      Color.RED);
      PlotFrame err_sin_x_frame = new PlotFrame("Function Errors",
                                                 err_sin_x_plot);
      err_sin_x_frame.setVisible(true);

      Plot2D comp_sin_x_plot = new Plot2D("Compare functions", "x", "sin_x");
      comp_sin_x_plot.storePlotValues("Math.sin(x)",
                                      x_values,
                                      actual_sin_x_values,
                                      Color.green);
      comp_sin_x_plot.storePlotValues("My sin(x)",
                                      x_values,
                                      my_sin_x_values,
                                      Color.red);
      PlotFrame comp_sin_x_frame = new PlotFrame("Comparison for Errors",
                                                 comp_sin_x_plot);
      comp_sin_x_frame.setVisible(true);

      double err_range = err_max - err_min;
      double err_scale = 100.0 / err_range;
      System.out.println("   err_min = " + err_min + "\n"
                       + "   err_max = " + err_max + "\n"
                       + "   err_range = " + err_range + "\n"
                       + "   err_scale = " + err_scale + "\n"
                        );

      double [] bin_err_values = new double[101];
      int [] hist = new int[101];
      for (int bin_index = 0;
           bin_index <= 100;
           bin_index++)
         {
         hist[bin_index] = 0;
         bin_err_values[bin_index] = err_min +
                                     (err_range * (double) bin_index / 100.0);
         }

      for (int x_index = 0;
           x_index < y_errors.length;
           x_index++)
         {
         double err_value = y_errors[x_index];
         int bin_index = (int) ((err_value - err_min) * err_scale);
         hist[bin_index]++;
         }

      for (int value_index = 0;
           value_index < bin_err_values.length;
           value_index++)
         {
         double x_value = bin_err_values[value_index];
         double y_value = (double) hist[value_index];

         String out_line = String.format("plf_2_tst: %3d (%9.3g, %9.3g)",
                                         value_index,
                                         x_value,
                                         y_value);
         System.out.println(out_line);
         }

      try
         {
         histogram = new Function_1D("Error Histogram",
                                     err_min,
                                     err_max,
                                     hist);
         }
      catch(Exception except)
         {
         System.out.println("plf_2_tst caught exception:\n"
                          + "   " + except);
         except.printStackTrace(System.out);
         }
      histogram.Print();

      Plot2D hist_plot = new Plot2D("Error Histogram", "error", "count");
      hist_plot.storePlotValues("Error Counts",
                                bin_err_values,
                                hist,
                                Color.green);
      PlotFrame hist_plot_frame = new PlotFrame("Histogram of Errors",
                                                 hist_plot);
      hist_plot_frame.setVisible(true);

      double [] pdf = new double[101];

      for (int bin_index = 0;
           bin_index <= 100;
           bin_index++)
         {
         pdf[bin_index] = (double) hist[bin_index] / sample_count;
         }

      try
         {
         pdf_plf = new Function_1D("Error PDF",
                                   err_min,
                                   err_max,
                                   pdf);
         }
      catch(Exception except)
         {
         System.out.println("plf_2_tst caught exception:\n"
                          + "   " + except);
         except.printStackTrace(System.out);
         }
      pdf_plf.Print();
      Plot2D pdf_plot = new Plot2D("Error PDF", "error", "probability");
      pdf_plot.storePlotValues("Error PDF",
                                bin_err_values,
                                pdf,
                                Color.green);
      PlotFrame pdf_plot_frame = new PlotFrame("Errors PDF",
                                                 pdf_plot);
      pdf_plot_frame.setVisible(true);
      
      try
         {
         cdf_plf = pdf_plf.Integrate("CDF = Integral[0, x] of PDF");
         }
      catch(Exception except)
         {
         System.out.println("plf_2_tst caught exception:\n"
                          + "   " + except);
         except.printStackTrace(System.out);
         }
      cdf_plf.Print();
      Plot2D cdf_plot = new Plot2D("Error CDF", "error", "probability");
      cdf_plot.storePlotValues("Error CDF",
                                bin_err_values,
                                cdf_plf.getValues(),
                                Color.green);
      PlotFrame cdf_plot_frame = new PlotFrame("Errors CDF",
                                                 cdf_plot);
      cdf_plot_frame.setVisible(true);

      System.out.println("plf_2_tst of Function_3D is DONE.\n");

      System.out.println("plf_2_tst DONE.\n");
      }
   }
