
/*
*  The Plot3D definition.
*/

package plot;


import java.util.*;

import java.awt.*;

import util.*;

/**
*  This class defines the basic 3-D plot structure used by the PlotPanel
*  to display the 3-D plot data using a simple isometric projection of
*  a 3-D rectangular plot area with separate plot lines for each plot item
*  (data line).
*
*  Features for plot surfaces and grids are DUMMIED and missing at this time.
*/
public class Plot3D
   {

   String title = "Title";

   String axis_x_title = "X-Axis";
   String axis_y_title = "Y-Axis";
   String axis_z_title = "Z-Axis";

   double x_min;
   double x_max;

   double y_min;
   double y_max;

   double z_min;
   double z_max;

   Axis axis_x = null;
   Axis axis_y = null;
   Axis axis_z = null;

   ArrayList<PlotItem> plot_items = null;

   Color title_color = Color.BLACK;
   Color grid_color = Color.darkGray;
   Color plot_color = Color.BLACK;

   double x_values_max = 1.0;
   double x_values_min = 0.0;
   double x_values_range = 1.0;

   double y_values_max = 1.0;
   double y_values_min = 0.0;
   double y_values_range = 1.0;

   double z_values_max = 1.0;
   double z_values_min = 0.0;
   double z_values_range = 1.0;

   boolean display_tics = true;
   boolean display_grid = true;
   boolean display_frame = true;

   /**
   *  Create the plot object with the given titles/labels.
   *  @param title the overall plot title to use.
   *  @param axis_x_title the title for the x axis.
   *  @param axis_y_title the title for the y axis.
   *  @param axis_z_title the title for the z axis.
   */
   public Plot3D(String title,
                 String axis_x_title,
                 String axis_y_title,
                 String axis_z_title)
      {
      this.title = title;
      this.axis_x_title = axis_x_title;
      this.axis_y_title = axis_y_title;
      this.axis_z_title = axis_z_title;

/*
      System.out.println("Plot3D Constructor on ENTRY:\n"
                       + "   title = " + this.title + "\n"
                       + "   axis_x_title = " + this.axis_x_title + "\n"
                       + "   axis_y_title = " + this.axis_y_title + "\n"
                       + "   axis_z_title = " + this.axis_z_title + "\n"
                        );
*/

      this.axis_x = new Axis(this.axis_x_title);
      this.axis_y = new Axis(this.axis_y_title);
      this.axis_z = new Axis(this.axis_z_title);

      this.plot_items = new ArrayList<PlotItem>();

/*
      System.out.println("Plot3D Constructor on EXIT.");
*/
      }

   /**
   *  Store another set of plot points (a single line) along with
   *  their color.
   *  @param key_string the key string for the line.
   *  @param x_values the array of x-values.
   *  @param y_values the array of y-values.
   *  @param z_values the array of z-values.
   *  @param color the color for the line.
   */
   public void storePlotValues(String key_string,
                               double [] x_values,
                               double [] y_values,
                               double [] z_values,
                               Color color)
      {
/*
      System.out.println("Plot3D::storePlotValues on ENTRY:\n"
                       + "   key_string = " + key_string + "\n"
                        );
*/

      PlotItem plot_item = new PlotItem(key_string,
                                        x_values,
                                        y_values,
                                        z_values,
                                        color);

      boolean x_limits_changed = false;
      boolean y_limits_changed = false;
      boolean z_limits_changed = false;

      if (this.plot_items.size() < 1)
         {
         this.x_values_max = plot_item.x_data_max;
         this.x_values_min = plot_item.x_data_min;
         x_limits_changed = true;
         this.y_values_max = plot_item.y_data_max;
         this.y_values_min = plot_item.y_data_min;
         y_limits_changed = true;
         this.z_values_max = plot_item.z_data_max;
         this.z_values_min = plot_item.z_data_min;
         z_limits_changed = true;
         }
      else
         {
         if (this.x_values_max < plot_item.x_data_max)
            {
            this.x_values_max = plot_item.x_data_max;
            x_limits_changed = true;
            }
         if (this.x_values_min > plot_item.x_data_min)
            {
            this.x_values_min = plot_item.x_data_min;
            x_limits_changed = true;
            }

         if (this.y_values_max < plot_item.y_data_max)
            {
            this.y_values_max = plot_item.y_data_max;
            y_limits_changed = true;
            }
         if (this.y_values_min > plot_item.y_data_min)
            {
            this.y_values_min = plot_item.y_data_min;
            y_limits_changed = true;
            }

         if (this.z_values_max < plot_item.z_data_max)
            {
            this.z_values_max = plot_item.z_data_max;
            z_limits_changed = true;
            }
         if (this.z_values_min > plot_item.z_data_min)
            {
            this.z_values_min = plot_item.z_data_min;
            z_limits_changed = true;
            }
         }

      this.plot_items.add(plot_item);

      if (x_limits_changed)
         {
         try
            {
            axis_x.updateAxis(this.axis_x_title,
                              this.x_values_min,
                              this.x_values_max,
                              false,
                              false);
            }
         catch (Exception except)
            {
            System.out.println("Plot3D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }
      if (y_limits_changed)
         {
         try
            {
            axis_y.updateAxis(this.axis_y_title,
                              this.y_values_min,
                              this.y_values_max,
                              false,
                              true);
            }
         catch (Exception except)
            {
            System.out.println("Plot3D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }
      if (z_limits_changed)
         {
         try
            {
            axis_z.updateAxis(this.axis_z_title,
                              this.z_values_min,
                              this.z_values_max,
                              false,
                              true);
            }
         catch (Exception except)
            {
            System.out.println("Plot3D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }

/*
      System.out.println("Plot3D::storePlotValues on EXIT.");
*/
      }

   /**
   *  Store another set of plot points (a single line) along with
   *  their color.
   *  @param key_string the key string for the line.
   *  @param x_values the array of double x-values.
   *  @param y_values the array of integer y-values.
   *  @param z_values the array of integer z-values.
   *  @param color the color for the line.
   */
   public void storePlotValues(String key_string,
                               double [] x_values,
                               int [] y_values,
                               int [] z_values,
                               Color color)
      {
/*
*/
      System.out.println("Plot3D::storePlotValues on ENTRY:\n"
                       + "   key_string = " + key_string + "\n"
                        );
      for (int value_index = 0;
           value_index < x_values.length;
           value_index++)
         {
         double x_value = x_values[value_index];
         double y_value = (double) y_values[value_index];
         double z_value = (double) z_values[value_index];

         String out_line = String.format("Plot3D: %3d (%9.3g, %9.3g, %9.3g)",
                                         value_index,
                                         x_value,
                                         y_value,
                                         z_value);
         System.out.println(out_line);
         }

      PlotItem plot_item = new PlotItem(key_string,
                                        x_values,
                                        y_values,
                                        z_values,
                                        color);

      boolean x_limits_changed = false;
      boolean y_limits_changed = false;
      boolean z_limits_changed = false;

      if (this.plot_items.size() < 1)
         {
         this.x_values_max = plot_item.x_data_max;
         this.x_values_min = plot_item.x_data_min;
         x_limits_changed = true;
         this.y_values_max = plot_item.y_data_max;
         this.y_values_min = plot_item.y_data_min;
         y_limits_changed = true;
         this.z_values_max = plot_item.z_data_max;
         this.z_values_min = plot_item.z_data_min;
         z_limits_changed = true;
         }
      else
         {
         if (this.x_values_max < plot_item.x_data_max)
            {
            this.x_values_max = plot_item.x_data_max;
            x_limits_changed = true;
            }
         if (this.x_values_min > plot_item.x_data_min)
            {
            this.x_values_min = plot_item.x_data_min;
            x_limits_changed = true;
            }

         if (this.y_values_max < plot_item.y_data_max)
            {
            this.y_values_max = plot_item.y_data_max;
            y_limits_changed = true;
            }
         if (this.y_values_min > plot_item.y_data_min)
            {
            this.y_values_min = plot_item.y_data_min;
            y_limits_changed = true;
            }

         if (this.z_values_max < plot_item.z_data_max)
            {
            this.z_values_max = plot_item.z_data_max;
            z_limits_changed = true;
            }
         if (this.z_values_min > plot_item.z_data_min)
            {
            this.z_values_min = plot_item.z_data_min;
            z_limits_changed = true;
            }
         }

      this.plot_items.add(plot_item);

      if (x_limits_changed)
         {
         try
            {
            axis_x.updateAxis(this.axis_x_title,
                              this.x_values_min,
                              this.x_values_max,
                              false,
                              false);
            }
         catch (Exception except)
            {
            System.out.println("Plot3D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }
      if (y_limits_changed)
         {
         try
            {
            axis_y.updateAxis(this.axis_y_title,
                              this.y_values_min,
                              this.y_values_max,
                              false,
                              true);
            }
         catch (Exception except)
            {
            System.out.println("Plot3D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }
      if (z_limits_changed)
         {
         try
            {
            axis_z.updateAxis(this.axis_z_title,
                              this.z_values_min,
                              this.z_values_max,
                              false,
                              true);
            }
         catch (Exception except)
            {
            System.out.println("Plot3D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }

/*
      System.out.println("Plot3D::storePlotValues on EXIT.");
*/
      }

   /**
   *  Store a set of plot points (a single line) by selecting columns out
   *  of a "Table" array of rows, each with an array of columns, along with
   *  their color.  An array list of ArrayList entries is passed in
   *  and the indices select which indices to pick out of each of
   *  the ArrayList entries for each of the variables.
   *  @param key_string the key string for the line.
   *  @param values the ArrayList of entries of ArrayList values.
   *  @param first_entry_index the index of the first (x) value.
   *  @param second_entry_index the index of the second (y) value.
   *  @param third_entry_index the index of the third (z) value.
   *  @param radius the radius of the dot to use (&lt; 1 for just a line).
   *  @param color the color for the dot and line.
   */
   public void storePlotValues(String key_string,
                               ArrayList<ArrayList<Double>> values,
                               int first_entry_index,
                               int second_entry_index,
                               int third_entry_index,
                               int radius,
                               Color color)
      {
/*
      System.out.println("Plot3D::storePlotValues on ENTRY:\n"
                       + "   key_string = " + key_string + "\n"
                        );
*/
      PlotItem plot_item = new PlotItem(key_string,
                                        values,
                                        first_entry_index,
                                        second_entry_index,
                                        third_entry_index,
                                        radius,
                                        color);

      boolean x_limits_changed = false;
      boolean y_limits_changed = false;
      boolean z_limits_changed = false;

      if (this.plot_items.size() < 1)
         {
         this.x_values_max = plot_item.x_data_max;
         this.x_values_min = plot_item.x_data_min;
         x_limits_changed = true;
         this.y_values_max = plot_item.y_data_max;
         this.y_values_min = plot_item.y_data_min;
         y_limits_changed = true;
         this.z_values_max = plot_item.z_data_max;
         this.z_values_min = plot_item.z_data_min;
         z_limits_changed = true;
         }
      else
         {
         if (this.x_values_max < plot_item.x_data_max)
            {
            this.x_values_max = plot_item.x_data_max;
            x_limits_changed = true;
            }
         if (this.x_values_min > plot_item.x_data_min)
            {
            this.x_values_min = plot_item.x_data_min;
            x_limits_changed = true;
            }

         if (this.y_values_max < plot_item.y_data_max)
            {
            this.y_values_max = plot_item.y_data_max;
            y_limits_changed = true;
            }
         if (this.y_values_min > plot_item.y_data_min)
            {
            this.y_values_min = plot_item.y_data_min;
            y_limits_changed = true;
            }

         if (this.z_values_max < plot_item.z_data_max)
            {
            this.z_values_max = plot_item.z_data_max;
            z_limits_changed = true;
            }
         if (this.z_values_min > plot_item.z_data_min)
            {
            this.z_values_min = plot_item.z_data_min;
            z_limits_changed = true;
            }
         }

      this.plot_items.add(plot_item);

      if (x_limits_changed)
         {
         try
            {
            axis_x.updateAxis(this.axis_x_title,
                              this.x_values_min,
                              this.x_values_max,
                              false,
                              false);
            }
         catch (Exception except)
            {
            System.out.println("Plot3D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }
      if (y_limits_changed)
         {
         try
            {
            axis_y.updateAxis(this.axis_y_title,
                              this.y_values_min,
                              this.y_values_max,
                              false,
                              true);
            }
         catch (Exception except)
            {
            System.out.println("Plot3D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }
      if (z_limits_changed)
         {
         try
            {
            axis_z.updateAxis(this.axis_z_title,
                              this.z_values_min,
                              this.z_values_max,
                              false,
                              true);
            }
         catch (Exception except)
            {
            System.out.println("Plot3D::storePlotValues ERROR:\n"
                               + "   \"" + except + "\"");
            except.printStackTrace(System.out);
            }
         }

/*
      System.out.println("Plot3D::storePlotValues on EXIT.");
*/
      }

   /**
   *  Get the designated plot item structure reference.
   *  @param item_index the index of the ploit item to fetch.
   *  @return the reference to the desired PlotItem class instance.
   */
   public PlotItem getPlotItem(int item_index)
      {
/*
      System.out.println("Plot3D::getPlotItem on ENTRY:\n"
                       + "   item_index = " + item_index + "\n"
                        );
*/
      return(this.plot_items.get(item_index));
      }

   /**
   *  Set the menu entries according to the status of the plot items.
   */
   public ArrayList<PlotItem> getPlotItems()
      {
      return(this.plot_items);
      }
   }

