
/*
*  The Frame for containing a PlotFrame to display and control the
*  Plot.
*/

package plot;


import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import util.*;
import plot.*;


/**
*  This class supplies a top-level window to separately display a Plot.
*/
public class PlotFrame extends JFrame
   {
   static final long serialVersionUID = 1L;

   private static final int DEFAULT_WIDTH = 600;
   private static final int DEFAULT_HEIGHT = 350;

   private static int x_offset = 20;
   private static int y_offset = 20;

   private PlotFrame plot_frame = null;
   private PlotPanel plot_panel = null;
   private String title = null;


   /**
   *  Creates a new instance of the PlotFrame and its contained
   *  PlotPanel.
   *  @param title the title to give the displayed frame.
   *  @param plot the plot object to display.
   */
   public PlotFrame(String title,
                    Plot2D plot)
      {
/*
      System.out.println("PlotFrame::constructor() #1 on ENTRY.");
*/

      this.plot_frame = this;

      if (title == null)
         {
         this.title = "Test Plot2D";
         }
      else
         {
         this.title = title;
         }
      setTitle(this.title);

      this.plot_panel = new PlotPanel(this, plot);

      x_offset += 50;
      y_offset += 50;
      Point loc = new Point(x_offset, y_offset);
      this.setLocation(loc);

      setSize(DEFAULT_WIDTH + 10, DEFAULT_HEIGHT + 30);

      addWindowListener(new PlotFrameWindowAdapter());

      setContentPane(this.plot_panel);

      repaint();
/*
      System.out.println("PlotFrame::constructor() #1 on EXIT.");
*/
      }


   /**
   *  Creates a new instance of the PlotFrame and its contained
   *  PlotPanel.
   *  @param title the title to give the displayed frame.
   *  @param scrolled_plot the scrolled plot object to display.
   */
   public PlotFrame(String title,
                    ScrolledPlot scrolled_plot)
      {
/*
      System.out.println("PlotFrame::constructor() #2 on ENTRY.");
*/

      this.plot_frame = this;

      if (title == null)
         {
         this.title = "Test Plot2D";
         }
      else
         {
         this.title = title;
         }
      setTitle(this.title);

      this.plot_panel = new PlotPanel(this, scrolled_plot);

      x_offset += 50;
      y_offset += 50;
      Point loc = new Point(x_offset, y_offset);
      this.setLocation(loc);

      setSize(DEFAULT_WIDTH + 10, DEFAULT_HEIGHT + 30);

      addWindowListener(new PlotFrameWindowAdapter());

      setContentPane(this.plot_panel);

      repaint();
/*
      System.out.println("PlotFrame::constructor() #2 on EXIT.");
*/
      }

   /**
   *  Creates a new instance of the PlotFrame and its contained
   *  PlotPanel.
   *  @param title the title to give the displayed frame.
   *  @param plot the plot object to display.
   *  @param x_values the x-values to use in the plot.
   *  @param y_values the y-values to use in the plot.
   */
   public PlotFrame(String title,
                    Plot2D plot,
                    double [] x_values,
                    double [] y_values)
      {
/*
      System.out.println("PlotFrame::constructor() #3 on ENTRY.");
*/

      this.plot_frame = this;

      if (title == null)
         {
         this.title = "Test Plot2D #3";
         }
      else
         {
         this.title = title;
         }
      setTitle(this.title);

      plot.storePlotValues("Values",
                           x_values,
                           y_values,
                           Color.RED);
      this.plot_panel = new PlotPanel(this, plot);

      x_offset += 50;
      y_offset += 50;
      Point loc = new Point(x_offset, y_offset);
      this.setLocation(loc);

      setSize(DEFAULT_WIDTH + 10, DEFAULT_HEIGHT + 30);

      addWindowListener(new PlotFrameWindowAdapter());

      setContentPane(this.plot_panel);

      repaint();
/*
      System.out.println("PlotFrame::constructor() #3 on EXIT.");
*/
      }

   class PlotFrameWindowAdapter extends WindowAdapter
      {
      public void windowClosing(WindowEvent event)
         {
         System.exit(0);
/*
         plot_frame.setVisible(false);
*/
         }
     }

   /**
   *  Clears the currently displayed Plot2D view.
   */
   public void clear()
      {
      plot_panel.clear();
      repaint();
      }


   /**
   *  Sets a new plot for the panel to display.
   *  @param plot the Plot2D object to be displayed.
   */
   public void display(Plot2D plot)
      {
      plot_panel.setPlot(plot);
      repaint();
      }


   /**
   *  Sets a new scrolled plot for the panel to display.
   *  @param scrolled_plot the Plot2D object to be displayed.
   */
   public void display(ScrolledPlot scrolled_plot)
      {
      plot_panel.setPlot(scrolled_plot);
      repaint();
      }


   /**
   *  Returns a reference to the contained plot panel.
   *  @return the plot display panel reference.
   */
   public PlotPanel getPanel()
      {
      return(plot_panel);
      }
   }

