
package util;

import java.util.*;
import java.io.*;

import util.geom.*;

/**
*  This class defines a feature point, storing its location in the
*  feature space, 1, 2, or 3-dimensional.
*/
public class F_Point extends Feature
   {

   /*
   *  The feature point location in the data.
   */
   VectorND location = null;

   /**
   *  Constructor for a pair representation of objects of the same type.
   *  @param coords the coordinate values.
   */
   public F_Point(double ... coords)
      {
      super("Point", coords.length);
      this.location = new VectorND(coords);
      }

   /**
   *  Constructor for a pair representation of objects of the same type.
   *  @param coords the coordinate values.
   */
   public F_Point(VectorND coords)
      {
      super("Point", coords.size());
      this.location = coords;
      }

   /**
   *  Get the location of the point.
   *  @return the location of the point.
   */
   public VectorND getLocation()
      {
      return(this.location);
      }

   /**
   *  Get the direction to the other point.
   *  @return the direction of the other point.
   */
   public VectorND getDirectionTo(F_Point other_point)
      {
      VectorND direction = other_point.location.subtract(this.location);

      direction.normalizeL2();

      return(direction);
      }

   /**
   *  Generate a string representation.
   *  @return the string representation.
   */
   public String toString()
      {
      String out_string = super.toString();
      out_string += this.prefix
                  + "   Location: " + this.location;
      return(out_string);
      }

   /**
   *  Print the string representation.
   */
   public void Print()
      {
      System.out.print(this);
      }

   /*
   * The functions for determining the feature type efficiently.
   */

   /*
   * Is it a Point?
   * @returns true if it is.
   */
   public boolean isPoint()
      {
      return(true);
      }

   /*
   * Is it a Sequence?
   * @returns true if it is.
   */
   public boolean isSequence()
      {
      return(false);
      }

   /*
   * Is it a Interval?
   * @returns true if it is.
   */
   public boolean isInterval()
      {
      return(false);
      }

   /*
   * Is it a Region?
   * @returns true if it is.
   */
   public boolean isRegion()
      {
      return(false);
      }
   }
