
package util;

import java.util.*;
import java.io.*;

/**
*  This class allows storing pairs of objects as a single entity.
*/
public class Pair<ObjType>
   {

   /*
   *  The pair of objects.
   */
   ObjType first_entry;
   ObjType second_entry;

   /**
   *  Constructor for a pair representation of objects of the same type.
   *  @param first_entry the first of the two objects.
   *  @param second_entry the first of the two objects.
   */
   public Pair(ObjType first_entry,
               ObjType second_entry)
      {
      this.first_entry = first_entry;
      this.second_entry = second_entry;
      }

   /**
   *  Constructor for a pair representation of objects of the same type.
   *  @param other_obj the object to clone.
   */
   public Pair(Pair<ObjType> other_obj)
      {
      this.first_entry = other_obj.getFirstEntry();
      this.second_entry = other_obj.getSecondEntry();
      }


  /**
  *  Get the first entry of the pair.
  *  @return the reference to the first entry.
  */
   public ObjType getFirstEntry()
      {
      return(this.first_entry);
      }

  /**
  *  Set the first entry of the pair.
  *  @param first_entry the first of the two objects.
  */
   public void set_first_entry(ObjType first_entry)
      {
      this.first_entry = first_entry;
      }

  /**
  *  Get the second entry of the pair.
  *  @return the reference to the second entry.
  */
   public ObjType getSecondEntry()
      {
      return(this.second_entry);
      }

  /**
  *  Get the second entry of the pair.
  *  @param second_entry the second of the two objects.
  */
   public void set_second_entry(ObjType second_entry)
      {
      this.second_entry = second_entry;
      }

  /**
  *  Generate a string representation of the contents of the pair.
  *  @return the string representation of the Pair.
  */
   public String toString()
      {
      String out_string = new String("");

      out_string = "(" + this.first_entry + ", " + this.second_entry + ")";
      return(out_string);
      }

  /**
  *  Print a string representation of the contents of the pair.
  */
   public void Print()
      {
      System.out.print("(" + this.first_entry + ", " + this.second_entry + ")");
      }
   }
