
package util.geom;

import java.util.*;
import java.io.*;

import util.*;

/**
*  This class allows storing 3-D coordinates.
*/
public class CoordsND extends VectorND
   {

   /**
   *  Creates a CoordsND object with 0.0 as each of the component values.
   *  @param num_dims the number of dimensions to initialize to 0.0
   */
   public CoordsND(int num_dims)
      {
      super(num_dims);
      }

   /**
   *  Creates a CoordsND object with (x, y, and z) component values.
   *  @param coords the array of coordinate values.
   */
   public CoordsND(double [] coords)
      {
      super(coords);
      }

   /**
   *  Creates a CoordsND object from a VectorND argument's component values.
   *  @param vector the coords class instance.
   */
   public CoordsND(VectorND vector)
      {
      super(vector);
      }

   /**
   * Creates a new CoordsND object from the CoordsND's component values.
   * @return the new CoordsND object reference.
   */
   public CoordsND clone()
      {
      CoordsND coords = new CoordsND(this);
      return(coords);
      }
   }

