
package util.geom;

import java.util.*;
import java.io.*;


/**
*  This class allows storing 3-D point coordinates.
*/
public class PointND extends VectorND
   {

   /**
   *  Creates a PointND object with (0, 0, 0) as the coordinate values.
   *  @param num_dims the number of dimensions to initialize to 0.0
   */
   public PointND(int num_dims)
      {
      super(num_dims);
      }

   /**
   *  Creates a PointND object from an array of coordinate values.
   *  @param vector the array of coordinate values.
   */
   public PointND(double [] vector)
      {
      super(vector);
      }

   /**
   *  Creates a PointND object from a VectorND argument's vector values.
   *  @param vector the other vector.
   */
   public PointND(VectorND vector)
      {
      super(vector);
      }

   /**
   * Creates a new PointND object from this PointND's coordinate values.
   * @return the new PointND object reference.
   */
   public PointND clone()
      {
      PointND point = new PointND(this);
      return(point);
      }
   }

