
package util;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
*  From the book:
*    "Thinking in Java" by Bruce Eckel,
*    Prentice Hall, 3rd edition, 2003.
* 
*  He develops his own "wrapper classes" which allow the applet to run
*  standalone or as an applet/servlet.
*  This file implements his framework.
*/
public class Console
   {
   /**
   *  Create the title string from the class name.
   *  @param obj the object whose class name is to be extracted and returned.
   *  @return the object's class name.
   */
   public static String title(Object obj)
      {
      String t_string = obj.getClass().toString();
      /*
      *  Remove the word "class".
      */
      if (t_string.indexOf("class") != -1)
         {
         t_string = t_string.substring(6);
         }
      return(t_string);
      }

   /**
   *  Activate the frame the given size.
   *  @param frame the frame to be activated.
   *  @param width the window width to use.
   *  @param height the window height to use.
   *
   */
   public static void run(JFrame frame, int width, int height)
      {
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      frame.setSize(width, height);
      frame.setVisible(true);
      }

   /**
   *  Activate the applet the given size.
   *  @param applet the applet to be activated.
   *  @param width the window width to use.
   *  @param height the window height to use.
   *
   */
   public static void run(JApplet applet, int width, int height)
      {
      JFrame frame = new JFrame(title(applet));
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      frame.getContentPane().add(applet);
      frame.setSize(width, height);
      applet.init();
      applet.start();
      frame.setVisible(true);
      }

   /**
   *  Activate the panel the given size.
   *  @param panel the panel to be activated.
   *  @param width the window width to use.
   *  @param height the window height to use.
   *
   */
   public static void run(JPanel panel, int width, int height)
      {
      JFrame frame = new JFrame(title(panel));
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      frame.getContentPane().add(panel);
      frame.setSize(width, height);
      frame.setVisible(true);
      }
   }

