
package util;

import java.util.*;
import java.io.*;

/**
*  This class allows storing 3-D point coordinates.
*/
public class Point3D extends Vector3D
   {

   /**
   *  Creates a Point3D object with (0, 0, 0) as the coordinate values.
   */
   public Point3D()
      {
      }

   /**
   *  Creates a Point3D object with (x, y, and z) coordinate values.
   *  @param x the x-coordinate.
   *  @param y the y-coordinate.
   *  @param z the z-coordinate.
   */
   public Point3D(double x, double y, double z)
      {
      super(x, y, z);
      }

   /**
   *  Creates a Point3D object from a Point3D argument's coordinate values.
   *  @param point the other point.
   */
   public Point3D(Point3D point)
      {
      super(point.x, point.y, point.z);
      }

   /**
   *  Creates a Point3D object from a Vector3D argument's coordinate values.
   *  @param vector the vector.
   */
   public Point3D(Vector3D vector)
      {
      super(vector.x, vector.y, vector.z);
      }

   /**
   * Creates a new Point3D object from the Point3D's coordinate values.
   * @return the new Point3D object reference.
   */
   public Point3D clone()
      {
      Point3D point = new Point3D(this);
      return(point);
      }

   /**
   *  Sets the Point3D location to the x, y, and Z coordinate values.
   *  @param x the x-coordinate.
   *  @param y the y-coordinate.
   *  @param z the z-coordinate.
   */
   public void setLocation(double x, double y, double z)
      {
      this.x = x;
      this.y = y;
      this.z = z;
      }

   /**
   *  Sets the Point3D object to the x, y, and Z coordinate values of
   *  another point.
   *  @param point the other point.
   */
   public void setLocation(Point3D point)
      {
      this.x = point.x;
      this.y = point.y;
      this.z = point.z;
      }
   }

