

/*
*  The interface SimEvent for notifying objects of their relevant events.
*/

package util;


import java.util.*;

import java.awt.*;
import java.awt.event.*;



/**
*  This class defines the basic SimEvent methods for passing event information
*  to the various classes that pass and receive the event objects.
*/
public class SimEvent
   {

   private static int next_id = 1;

   int event_id = -1;
   String type = null;

   /**
   *  Generates a SimEvent object of a given type.
   *  @param type the event type.
   */
   public SimEvent(String type)
      {
      this.event_id = next_id;
      next_id++;

      this.type = type;
      }

   /**
   *  Get the id of the event.
   *  @return the event_id value.
   */
   public int get_event_id()
      {
      return(this.event_id);
      }

   /**
   *  Get the type for the event.
   *  @return the event type value.
   */
   public String get_type()
      {
      return(this.type);
      }


   /**
   *  Create a representative string for this SimEvent object.
   *  @return the SimEvent string representation.
   */
   public String toString()
      {
      return("SimEvent ("
           + this.event_id
           + ": \""
           + this.type
           + "\")"
            );
      }


   /**
   *  Output a representative string for this SimEvent object.
   */
   public void Print()
      {
      System.out.print(this);
      }
   }

